///////////////
// View Item //
///////////////

#include "Card View.h"
#include "View List.h"

ViewItem::ViewItem ()
{
    Dragging = FALSE;
}

void ViewItem::Open ()
{
    AdjustWindow (*this);
    ShowWindow (SW_NORMAL);
    SetForegroundWindow ();
}

void ViewItem::StartDrag (HWND disable)
{
    static epp_Cursor Cursor;

    DragCard = GetCard ();

    if (DragCard) {
        ::EnableWindow (disable, FALSE);
        SetCapture ();

        if (!Cursor)
            Cursor.LoadCursor (IDC_CARD);

        OldCursor = SetCursor (Cursor);

        Dragging = TRUE;
        Disabled = disable;
    }
}

void ViewItem::SetRect ()
{
    if (!IsIconic () && !IsZoomed ())
        GetWindowRect (&_Rect);
}

void ViewItem::OnClose ()
{
    Hide ();
}

int ViewItem::OnCreate (CREATESTRUCT *)
{
    SetRect ();
    return 0;
}

void ViewItem::OnLButtonUp (int, int x, int y)
{
    CardView *card;
    ViewItem *view;

    if (Dragging) {
        SetCursor (OldCursor);
        ReleaseCapture ();
        ::EnableWindow (Disabled, TRUE);
        Dragging = FALSE;

        POINT point = {x, y};
        ClientToScreen (&point);
        view = Views.Find (point);

        if (view) {
            if (*view != *this) {
                view->Drop (DragCard);
            }
        } else {
            card = card = AllocCardView ();
            if (card) {
                card->Create (DragCard, point.x + 1, point.y + 1);
                card->Open ();
            }
        }
    }
}

void ViewItem::OnMove (int, int)
{
    SetRect ();
}

void ViewItem::OnSize (int, int, int)
{
    SetRect ();
}

LRESULT ViewItem::OnItemClose (WPARAM, LPARAM)
{
    Close ();
    return 0;
}

BEGIN_HANDLER (ViewItem, epp_Frame)
    ON_WM_LBUTTONUP
    ON_WM_MOVE
    ON_WM_SIZE
    ON_WM_CLOSE
    ON_WM_CREATE
    ON_WM_USER (ITEM_CLOSE, OnItemClose);
END_HANDLER

void AdjustWindow (epp_Window& window)
{
    RECT rect;
    BOOL resize;

    resize = FALSE;
    window.GetWindowRect (&rect);

    if (rect.right > GetSystemMetrics (SM_CXSCREEN)) {
        OffsetRect (&rect, GetSystemMetrics (SM_CXSCREEN) - rect.right, 0);
        resize = TRUE;
    }
    if (rect.bottom > GetSystemMetrics (SM_CYSCREEN)) {
        OffsetRect (&rect, 0, GetSystemMetrics (SM_CYSCREEN) - rect.bottom);
        resize = TRUE;
    }
    if (rect.left < 0) {
        rect.left = 0;
        resize = TRUE;
    }
    if (rect.top < 0) {
        rect.top = 0;
        resize = TRUE;
    }

    if (resize)
        window.MoveWindow (rect);
}